<!DOCTYPE html>
<html>

<head>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href="images/fav.png" rel="icon" />

    <title>Sesp</title>
    <link rel="stylesheet" href="css/icons.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css" integrity="sha384-xOolHFLEh07PJGoPkLv1IbcEPTNtaed2xpHsD9ESMhqIYd0nLMwNLD69Npy4HI+N" crossorigin="anonymous">
    <link rel="stylesheet" type="text/css" href="css/style.css">

    <link rel="stylesheet" type="text/css" href="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/assets/owl.carousel.min.css">
    <link rel="stylesheet" type="text/css" href="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/assets/owl.theme.default.min.css">
</head>

<body>
    <?php include 'include.php';?>
    <section class="inner-banner d-flex align-items-center">
        <div class="container-fluid">
            <h1>Go green</h1>
        </div>
    </section>

    <div class="container-fluid">
        <div class="section-space">
            <div class="headings-of-found">
                <h2 class="text-transfm">What is The <span>Go Green</span> Initiative?</span>
                </h2>
                <div class="image-bg-green d-flex align-items-center justify-content-center">
                    <img src="images/go-green.png" class="img-fluid gogreen-img">
                </div>
                <p>The Go Green Initiative is all about integrating technology into the curriculum at SESP. Go Green was formed within the first year of SESP’s operation and set about providing tablet computers for every trainee and instructor. Currently,
                    SESP’s 1:1 deployment of tablet computers (a device for every trainee) is now present at 3 campuses with over 500 iPads in the hands of instructors and trainees.</p>
                <p> Reducing paper usage across SESP is one benefit of each trainee having access to this technology. Many of the classroom materials are distributed digitally which helps our trainees to become more ecologically aware and ensures our daily
                    operations are more environmentally friendly. As a bonus, it saves our instructors time at the photocopy machine.</p>
                <p>A 1:1 deployment of iPads allows the curriculum to integrate the use of technology into every lesson. The use of technology in the classroom has helped to create engaging lessons and activities that were not possible previously. Our trainees
                    develop skills such as researching online, collaborating on online documents, consuming and creating video content or presenting important concepts and project work to their peers with the use of classroom technology. Completing such
                    tasks has helped foster creativity, collaboration, critical thinking and problem solving amongst our trainees.</p>
                <p>Transforming the classroom with the use of educational technology demands a new way of approaching instruction and exposes our trainees to new ways of learning. External and in-house training has helped support our instructors and trainees
                    during this transition. Go Green has worked with Apple to provide workshops to inspire and inform our instructors and leadership team. Additionally, Go Green has worked closely with our faculty to provide a series of training workshops
                    ahead of the deployment of the iPads as well as establishing ongoing training led by our own instructors.</p>
                <p>From the beginning of the Go Green initiative, SESP’s approach to instructional design and use of tablets in the classroom has been informed by experts in the field of educational technology. Theoretical models such as the SAMR model created
                    by Dr Ruben Puentedura have helped our instructors critically evaluate the use of technology in the classroom. The SAMR model describes how classroom tasks, which utilize technology, can simply enhance or transform learning. For example,
                    our trainees now publish their writing in English class and create instructional videos which are shared with other classes online. The intention for setting this type of task is for using technology to redefine learning rather than
                    simply substitute traditional classroom activities. It is critical that our instructors are conversant with such a model so that they can evaluate their own use of technology in the classroom and communicate teaching strategies with
                    their peers.</p>
                <p>SESP has carried out research investigating the use of technology in the classroom. Qualitative and quantitative research into instructors’ and trainees’ attitudes towards technology and their use of it in the classroom has helped to set
                    priorities for project planning and informs which topics are necessary for on-going professional development.</p>
                <p>Class time is a finite resource but a 1:1 deployment of mobile devices ensures trainees have access to all study materials on the go. SESP utilizes iTunes U as a platform for organizing courses and materials on the iPad. Course information,
                    contact details, lesson objectives, instruction and materials are all available to the trainees online and offline. Everything our trainees need for their lesson is provided ahead of time. This ‘flips’ the classroom so that more time
                    is spent on practice rather than instruction as well as freeing our instructors to follow up with individual trainees who need extra help.</p>
                <p>The 1:1 deployment of iPads has enabled SESP to carry out written assessments electronically. Using an online assessment platform, assessments are created from a central bank of questions written by our assessment team and then conducted
                    on the iPad through a native app in a secure setting. The advantages of using an online, assessment platform include delivering results for our trainees immediately, reducing paper use, additional security afforded by a centrally managed
                    system and the use of tools which allow analysis of student results and the effectiveness of individual assessment tasks.</p>
            </div>
        </div>


    </div>



    <div class="sec-pad">
        <?php include("footer.php")?>
    </div>

    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js" integrity="sha384-DfXdz2htPH0lsSSs5nCTpuj/zy4C+OGpamoFVy38MVBnE+IbbVYUew+OrCXaRkfj" crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.min.js" integrity="sha384-+sLIOodYLS7CIrQpBjl+C7nPvqq+FbNUBDunl/OZv93DB7Ln/533i8e/mZXLi/P+" crossorigin="anonymous"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/owl.carousel.min.js"></script>

</body>

</html>