<!DOCTYPE html>
<html>

<head>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href="images/fav.png" rel="icon" />

    <title>Sesp</title>
    <link rel="stylesheet" href="css/icons.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css" integrity="sha384-xOolHFLEh07PJGoPkLv1IbcEPTNtaed2xpHsD9ESMhqIYd0nLMwNLD69Npy4HI+N" crossorigin="anonymous">
    <link rel="stylesheet" type="text/css" href="css/style.css">

    <link rel="stylesheet" type="text/css" href="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/assets/owl.carousel.min.css">
    <link rel="stylesheet" type="text/css" href="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/assets/owl.theme.default.min.css">
</head>

<body>
    <?php include 'include.php';?>
    <section class="inner-banner d-flex align-items-center">
        <div class="container-fluid">
            <h1>About Us</h1>
        </div>
    </section>

    <div class="container-fluid  container-short-width">
        <div class="section-space">
            <div class="headings-of-found">
                <h2>Founder <span>partners</span></h2>
                <p>SESP came into being in 2012. Its two founding partners, Saudi Electricity Company (SEC) and the Technical and Vocational Training Corporation (TVTC) established the institution as a non- profit organization that would provide training
                    for Saudi employees with a difference. Each cadre of trainees was to benefit from internationally sourced trainers who had the expertise and qualifications required to produce top-rate graduates. Additionally, the company was to be
                    set up on the premise that international know-how would bring other rewards such as state of the art program delivery and quality systems. The Board of Trustees comprises members of both SEC and TVTC who lend their expertise, knowledge
                    and industrial experience in the power service industry and vocational training education to the training operations of SESP.</p>
                <p>While SESP’s vision and mission have evolved to allow the inclusion of other company sponsors from the power utility and construction industries, the Board of Trustees continues to provide the governing framework for SESP.</p>
            </div>
        </div>
        <div class="row section-found">
            <div class="col-lg-12">
                <div class="category-list-box align-items-center d-flex">
                    <a href="https://www.gunt.de/index.php?option=com_gunt&task=gunt.list.category&category_id=780&lang=en&Itemid=148" target="_blank"><img src="images/clients/1.png" class="img-fluid"></a>
                </div>
                <div class="category-list-box2 d-flex align-items-center">
                    <p>Famously based in Hamburg, Germany, Gunt have offices in more than 80 countries and are internationally renowned for developing and producing equipment that is used in technical education at vocational schools, technical colleges and
                        universities across the globe. At SESP, the inventory of equipment supplied by Gunt includes gas plants, compact steam turbines, hydraulic and pneumatic training systems, and a range of cutaway models.</p>
                </div>
            </div>
            <div class="col-lg-12">
                <div class="category-list-box align-items-center d-flex">
                    <a href="https://www.kemppi.com/en-US/" target="_blank"><img src="images/clients/2.png" class="img-fluid"></a>
                </div>
                <div class="category-list-box2 d-flex align-items-center">
                    <p>Founded in Finland in 1949, Kemppi is a world-leading manufacturer of welding equipment and a provider of solutions for highly-productive welding. SESP trainees from all disciplines learn how to weld using Kemppi’s MIG and oxyacetylene
                        welding machines, and WMC trainees go on to train in TIG and arc welding. SESP also makes use of Kemppi’s ProTrainer for welding process training in a virtual environment.</p>
                </div>
            </div>
            <div class="col-lg-12">
                <div class="category-list-box align-items-center d-flex">
                    <a href="https://www.pruftechnik.com/en-US/" target="_blank"><img src="images/clients/7.png" class="img-fluid"></a>
                </div>
                <div class="category-list-box2 d-flex align-items-center">
                    <p>Prüftechnik are the inventors of shaft alignment and have remained undisputed leaders of the industry ever since the introduction of Optalign, the world’s first laser-optical shaft alignment system, in 1984. At SESP, our PPM trainees
                        are trained to use Prüftechnik’s highly-versatile, best-in-class, all-in-one intelligent alignment platform, the Rotalign Ultra iS.</p>
                </div>
            </div>
            <div class="col-lg-12">
                <div class="category-list-box align-items-center d-flex">
                    <a href="https://www.colchester.co.uk/" target="_blank"><img src="images/clients/11.png" class="img-fluid"></a>
                </div>
                <div class="category-list-box2 d-flex align-items-center">
                    <p>The Colchester Lathe Company was first established in 1897, and is the largest turning machine builder in Europe. Their robust, versatile, geared head centre lathe, as found in SESP’s workshops, is the ultimate training lathe and the
                        number one choice of training establishments worldwide. All SESP trainees will be trained in basic lathe techniques and safety practices, and PPM trainees will receive intensive training in machining operations.</p>
                </div>
            </div>
            <div class="col-lg-12">
                <div class="category-list-box align-items-center d-flex">
                    <a href="https://www.tvtc.gov.sa/" target="_blank"><img src="images/clients/6.png" class="img-fluid"></a>
                </div>
                <div class="category-list-box2 d-flex align-items-center">
                    <p>Established by Royal decree in 1980, The Technical and Vocational Training Corporation (TVTC) is an umbrella organisation for all technical and vocational training in the Kingdom of Saudi Arabia. As the Saudi Government’s leading provider
                        of training, TVTC has branches in all major Saudi cities. Tasked with creating higher education opportunities for Saudi nationals to gain the skills and qualifications required by the Kingdom’s fast-developing industries, partnering
                        with SEC to found SESP has enabled TVTC to exceed their goals.</p>
                </div>
            </div>
            <div class="col-lg-12">
                <div class="category-list-box align-items-center d-flex">
                    <a href="https://eu.flukecal.com/" target="_blank"><img src="images/clients/10.png" class="img-fluid"></a>
                </div>
                <div class="category-list-box2 d-flex align-items-center">
                    <p>With factories in the United States and United Kingdom, Fluke Calibration products can be found in standards and calibration laboratories as well as industrial, plant and commercial facilities around the world, and consistently outperform
                        their specifications. At SESP, our trainees use a broad range of Fluke Calibration products, such as multimeters, clamp meters, low and high voltage insulation testers, earth resistance testers, infrared thermometers and scope
                        meters.
                    </p>
                </div>
            </div>
            <div class="col-lg-12">
                <div class="category-list-box align-items-center d-flex">
                    <a href="https://www.rockwellautomation.com/" target="_blank"><img src="images/clients/3.png" class="img-fluid"></a>
                </div>
                <div class="category-list-box2 d-flex align-items-center">
                    <p>Rockwell Automation was established in 1903 is now the world's largest company dedicated to industrial automation and information. Rockwell Automation’s legacy is marked by technology leadership and an unrelenting focus on innovation
                        and development. SESP recently purchased a state-of-the-art Rockwell Automation laboratory, in order to enrich our trainees’ experience with the automation knowledge and skills that are required by the power utility industry. SESP
                        can certify trainees in Programmable Logic Controller (PLC) maintenance and programming.</p>
                </div>
            </div>
            <div class="col-lg-12">
                <div class="category-list-box align-items-center d-flex">
                    <a href="https://global.abb/group/en" target="_blank"><img src="images/clients/4.png" class="img-fluid"></a>
                </div>
                <div class="category-list-box2 d-flex align-items-center">
                    <p>Founded in 1883, ABB have spent more than a century at the cutting edge of technology in power and automation and annually dedicate around $1.5bn to fund research and development activities which ensure they remain frontrunners in
                        the field. ABB recently supplied SESP with high-voltage, gas-insulated switchgears (GIS), and are gearing up to train SESP personnel in the intricacies of these top-of-the-range components.</p>
                </div>
            </div>
            <div class="col-lg-12">
                <div class="category-list-box align-items-center d-flex">
                    <a href="https://megger.com/" target="_blank"><img src="images/clients/5.png" class="img-fluid"></a>
                </div>
                <div class="category-list-box2 d-flex align-items-center">
                    <p>Established in the late 1800s and with manufacturing plants located in Germany, Sweden, the UK and the USA, Megger are world leaders in the design and manufacture of portable electrical testing equipment. As well as supplying SESP
                        with a wide range of equipment from their extensive product portfolio, Megger recently conducted training sessions for SESP’s technical instructors, to guarantee that their state-of-the-art technology is used with maximum effectiveness.</p>
                </div>
            </div>
            <div class="col-lg-12">
                <div class="category-list-box align-items-center d-flex">
                    <a href="https://www.mhi.ca/" target="_blank"><img src="images/clients/8.png" class="img-fluid"></a>
                </div>
                <div class="category-list-box2 d-flex align-items-center">
                    <p>MHI is a wholly owned subsidiary of Manitoba Hydro, one of the largest and longest-standing utilities in Canada. MHI is composed of five divisions: Manitoba Hydro International Utility Services, the Manitoba HVDC Research Centre, W.I.R.E.
                        Services, Manitoba Hydro Telecom, and Manitoba Hydro International Maintenance Services. In 2011, the divisions merged to form MHI, and deliver innovative products and services in their area of expertise. MHI has worked extensively
                        with SEC and its Transmission and Distribution Departments in bringing modern techniques and safety training both in the Kingdom and Canada. MHI as a partner to SESP is consulting on Course materials , practical training and assessment.</p>
                </div>
            </div>
            <div class="col-lg-12">
                <div class="category-list-box align-items-center d-flex">
                    <a href="https://www.lucas-nuelle.com/" target="_blank"><img src="images/clients/9.png" class="img-fluid"></a>
                </div>
                <div class="category-list-box2 d-flex align-items-center">
                    <p>Lucas Nülle training systems are manufactured at their headquarters in Germany and deployed throughout the world, where they are seen as a benchmark for quality, efficiency and technology. All equipment undergoes extensive operational
                        testing before leaving their premises in Cologne. Lucas Nülle’s UniTrain-I is a multimedia e-learning system with integrated mobile electronics laboratory, used by SESP’s electrical trainees to acquire an in-depth understanding
                        of electrical theory. SESP workshops also contain Lucas Nülle equipment dedicated specifically to training in domestic wiring and SCADA (supervisory control and data acquisition).</p>
                </div>
            </div>
        </div>


    </div>



    <div class="sec-pad">
        <?php include("footer.php")?>
    </div>

    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js" integrity="sha384-DfXdz2htPH0lsSSs5nCTpuj/zy4C+OGpamoFVy38MVBnE+IbbVYUew+OrCXaRkfj" crossorigin="anonymous"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.min.js" integrity="sha384-+sLIOodYLS7CIrQpBjl+C7nPvqq+FbNUBDunl/OZv93DB7Ln/533i8e/mZXLi/P+" crossorigin="anonymous"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/owl.carousel.min.js"></script>
</body>

</html>