<!DOCTYPE html>
<html lang="en">

<head>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link href="images/fav.png" rel="icon" />
    <title>Sesp</title>
    <link rel="stylesheet" href="css/icons.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/css/bootstrap.min.css"
        integrity="sha384-xOolHFLEh07PJGoPkLv1IbcEPTNtaed2xpHsD9ESMhqIYd0nLMwNLD69Npy4HI+N" crossorigin="anonymous">
    <link rel="stylesheet" type="text/css" href="css/style.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/magnific-popup.js/1.1.0/magnific-popup.css" />
    <link rel="stylesheet" href="css/rtl.css">
</head>

<body class="student-dashboard">

    <nav class="navbar navbar-expand-lg navbar-light student-nav fixed-top">
        <div class="container-fluid">
            <a class="navbar-brand" href="index.php"><img src="images/log.png" alt="" class="logo"></a>

            <div class="dropdown d-inline-block user-dropdown">
                <button type="button" class="btn header-item" id="page-header-user-dropdown" data-toggle="dropdown"
                    aria-haspopup="true" aria-expanded="false">
                    <img class="rounded-circle header-profile-user" src="images/avatar-1.jpeg" alt="Header Avatar">
                    <span class="d-none d-xl-inline-block ms-1" key="t-henry">هنري</span>
                    <i class="fas fa-angle-down"></i>
                </button>
                <div class="dropdown-menu dropdown-menu-end" style="">
                    <a class="dropdown-item" href="#"><i class="bx bx-user font-size-16 align-middle me-1"></i> <span
                            key="t-profile">حساب تعريفي</span></a>
                    <a class="dropdown-item" href="login.php"><i
                            class="bx bx-power-off font-size-16 align-middle me-1 text-danger"></i> <span
                            key="t-logout">تسجيل خروج</span></a>
                </div>
            </div>
        </div>
    </nav>

    <h2 class="dashboard-title">لوحة القيادة</h2>
    <div class="dashboard">
        <div class="row">

            <div class="col-md-9">
                <div class="profile-div">
                    <div class="profile-cover"></div>
                    <div class="profile-content">
                        <img src="images/user1.png" alt="" class="student-img">
                        <h2>أحلام بكر</h2>
                        <div class="pro-content-bottom">
                            <div class="row">
                                <div class="col-md-3">
                                    <label for="">الهوية الوطنية</label>
                                    <div class="pro-content-txt">
                                        <i class="fa-regular fa-address-card"></i>
                                        23856619
                                    </div>
                                </div>
                                <div class="col-md-5">
                                    <label for="">عنوان الايميل</label>
                                    <div class="pro-content-txt">
                                        <i class="fa-regular fa-envelope"></i>
                                        ahlambacker@gmail.com
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <label for="">تاريخ الميلاد</label>
                                    <div class="pro-content-txt">
                                        <i class="fa-regular fa-calendar"></i>
                                        29-01-2001
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row terms">
                    <div class="col-md-4">
                        <div class="card">
                            <div class="locaton-card">  
                                        <div class="row">
                                            <div class="col-lg-6 px-2">
                                                <h3>اختر مدينة</h3>
                                        
                                                <div class="form-grp">
                                                    <!-- <label for="main-location-type">Location</label> -->
                                                    <select class="form-control" id="main-location-type" onchange="changeFuncloc();">
                                                        <option style="display: none;">اختر المقاطعات</option>
                                                        <option value="1">الرياض</option>
                                                        <option value="2">مكه</option>
                                                        <option value="3">المدينة المنورة</option>
                                                        <option value="4">الشرقية</option>
                                                        <option value="5">القصيم</option>
                                                        <option value="6">عسير</option>
                                                        <option value="7">تبوك</option>
                                                        <option value="8">يشيد</option>
                                                        <option value="9">الحدود الشمالية</option>
                                                        <option value="10">جازان</option>
                                                        <option value="11">نجران</option>
                                                        <option value="12">الباحة</option>
                                                        <option value="13">الجوف</option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-lg-6 px-2">
                                                <div style="display: none;" id="riyadh-main">
                                                    <div class=" form-grp">
                                                        <label for="riyadh-main-city">الرياض</label>
                                                        <select class="form-control" id="riyadh-main-city">
                                                            <option style="display: none;">مدن أساسيه</option>
                                                            <option value="1">الخرج</option>
                                                            <option value="2">الدرعية</option>
                                                            <option value="3">الدوادمي</option>
                                                            <option value="4">المجمعة</option>
                                                            <option value="5">القويعية</option>
                                                            <option value="6">الدوادمي، عفيف</option>
                                                        </select>
                                                    </div>
                                                </div>
                
                                                <div style="display: none;" id="makkah-main">
                                                    <div class=" form-grp">
                                                        <label for="makkah-main-city">مكه</label>
                                                        <select class="form-control" id="makkah-main-city">
                                                            <option style="display: none;">مدن أساسيه</option>
                                                            <option value="1">جدة</option>
                                                            <option value="2">الطائف</option>
                                                            <option value="3">القنفذة</option>
                                                            <option value="4">الليث</option>
                                                            <option value="5">جوموم</option>
                                                            <option value="6">رابغ</option>
                                                        </select>
                                                    </div>
                                                </div>
                
                                                <div style="display: none;" id="medina-main">
                                                    <div class=" form-grp">
                                                        <label for="medina-main-city">المدينة المنورة</label>
                                                        <select class="form-control" id="medina-main-city">
                                                            <option style="display: none;">مدن أساسيه</option>
                                                            <option value="1">ينبع</option>
                                                            <option value="2">العلا</option>
                                                            <option value="3">محمد الذهب</option>
                                                            <option value="4">بدر</option>
                                                            <option value="5">خيبة</option>
                                                        </select>
                                                    </div>
                                                </div>
                
                                                <div style="display: none;" id="eastern-main">
                                                    <div class=" form-grp">
                                                        <label for="eastern-main-city">الشرقية</label>
                                                        <select class="form-control" id="eastern-main-city">
                                                        <option style="display: none;">مدن أساسيه</option>
                                                            <option value="1">مدينه الخبر</option>
                                                            <option value="2">الظهران</option>
                                                            <option value="3">الجبيل</option>
                                                            <option value="4">الهفوف، الأحساء</option>
                                                            <option value="5">القطيف</option>
                                                        </select>
                                                    </div>
                                                </div>
                
                                                <div style="display: none;" id="qassim-main">
                                                    <div class=" form-grp">
                                                        <label for="qassim-main-city">القصيم</label>
                                                        <select class="form-control" id="qassim-main-city">
                                                        <option style="display: none;">مدن أساسيه</option>
                                                            <option value="1">عنيزة</option>
                                                            <option value="2">الرس</option>
                                                            <option value="3">البكيرية</option>
                                                            <option value="4">المذنب</option>
                                                        </select>
                                                    </div>
                                                </div>
                
                                                <div style="display: none;" id="asir-main">
                                                    <div class=" form-grp">
                                                        <label for="asir-main-city">عسير</label>
                                                        <select class="form-control" id="asir-main-city">
                                                        <option style="display: none;">مدن أساسيه</option>
                                                            <option value="1">خميس مشيط</option>
                                                            <option value="2">بيشة، ظهران الجنوب</option>
                                                            <option value="3">تثليث</option>
                                                            <option value="4">سراة عبيدة</option>
                                                        </select>
                                                    </div>
                                                </div>
                
                                                <div style="display: none;" id="tabuk-main">
                                                    <div class=" form-grp">
                                                        <label for="tabuk-main-city">تبوك</label>
                                                        <select class="form-control" id="tabuk-main-city">
                                                        <option style="display: none;">مدن أساسيه</option>
                                                            <option value="1">تيماء</option>
                                                            <option value="2">حقل</option>
                                                            <option value="3">ضباء</option>
                                                            <option value="4">الوجه</option>
                                                        </select>
                                                    </div>
                                                </div>
                
                                                <div style="display: none;" id="hail-main">
                                                    <div class=" form-grp">
                                                        <label for="hail-main-city">يشيد</label>
                                                        <select class="form-control" id="hail-main-city">
                                                        <option style="display: none;">مدن أساسيه</option>
                                                            <option value="1">البقعة</option>
                                                            <option value="2">طريف، العويقلة</option>
                                                        </select>
                                                    </div>
                                                </div>
                
                                                <div style="display: none;" id="northern-main">
                                                    <div class=" form-grp">
                                                        <label for="northern-main-city">الحدود الشمالية</label>
                                                        <select class="form-control" id="northern-main-city">
                                                        <option style="display: none;">مدن أساسيه</option>
                                                            <option value="1">رفحاء</option>
                                                            <option value="2">طريف،</option>
                                                            <option value="3">العويقيلة</option>
                                                        </select>
                                                    </div>
                                                </div>
                
                                                <div style="display: none;" id="jizan-main">
                                                    <div class=" form-grp">
                                                        <label for="jizan-main-city">جازان</label>
                                                        <select class="form-control" id="jizan-main-city">
                                                        <option style="display: none;">مدن أساسيه</option>
                                                            <option value="1">صبيا</option>
                                                            <option value="2">ابو عريش</option>
                                                            <option value="3">صامطة</option>
                                                            <option value="4">جزيرة فرسان</option>
                                                        </select>
                                                    </div>
                                                </div>
                
                                                <div style="display: none;" id="najran-main">
                                                    <div class=" form-grp">
                                                        <label for="najran-main-city">نجران</label>
                                                        <select class="form-control" id="najran-main-city">
                                                        <option style="display: none;">مدن أساسيه</option>
                                                            <option value="1">شرورة</option>
                                                            <option value="2">هابونا</option>
                                                            <option value="3">بدر الجنوب</option>
                                                        </select>
                                                    </div>
                                                </div>
                
                                                <div style="display: none;" id="bahah-main">
                                                    <div class=" form-grp">
                                                        <label for="bahah-main-city">الباحة</label>
                                                        <select class="form-control" id="bahah-main-city">
                                                        <option style="display: none;">مدن أساسيه</option>
                                                            <option value="1">بلجرشي</option>
                                                            <option value="2">المندق</option>
                                                            <option value="3">العقيق</option>
                                                        </select>
                                                    </div>
                                                </div>
                                                
                                                <div style="display: none;" id="jawf-main">
                                                    <div class=" form-grp">
                                                        <label for="jawf-main-city">الجوف</label>
                                                        <select class="form-control" id="jawf-main-city">
                                                        <option style="display: none;">مدن أساسيه</option>
                                                            <option value="1">القريات</option>
                                                            <option value="2">دومة الجندل</option>
                                                            <option value="3">طبرجل</option>
                                                        </select>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>  
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="card">
                            <div class="card-body">
                                <div class="w-100 d-flex justify-content-between align-items-center">
                                    <div>
                                        <h3 data-toggle="modal" href="#terms-modal">شروط الاستخدام</h3>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" id="remember-check">
                                            <label class="form-check-label" for="remember-check">
                                            أنا موافق
                                            </label>
                                        </div>
                                    </div>
                                    <div class="arrow-div" data-toggle="modal" href="#terms-modal">
                                        <i class="fa-solid fa-arrow-left"></i>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="card">
                            <div class="card-body">
                                <div class="w-100 d-flex justify-content-between align-items-center">
                                    <div>
                                        <h3 data-toggle="modal" href="#privacy-modal">سياسة الخصوصية</h3>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" id="remember-check">
                                            <label class="form-check-label" for="remember-check">
                                            لقد قرأت
                                            </label>
                                        </div>
                                    </div>
                                    <div class="arrow-div" data-toggle="modal" href="#privacy-modal">
                                        <i class="fa-solid fa-arrow-left"></i>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
                <div class="card">
                    <div class="card-body">
                        <table class="table course-tbl">
                            <thead>
                                <tr>
                                    <th>نوع الدبلوم</th>
                                    <th>الفصل الدراسي/السنة</th>
                                    <th>برنامج</th>
                                    <th>عنوان الدورة</th>
                                    <th></th>

                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>SESP الدورات</td>
                                    <td>يسقط</td>
                                    <td>دبلوم مشارك في الصحة والسلامة والبيئة</td>
                                    <td>تكنولوجيا الصحة والسلامة والبيئة (HSET)</td>
                                    <td class="text-right">
                                        <div class="table-icons">
                                            <i class="fa-solid fa-plus icn1" data-toggle="modal" href="#add-course"></i>
                                            <i class="fa-solid fa-trash icn2 remove-tr"></i>
                                        </div>

                                    </td>
                                </tr>



                            </tbody>
                        </table>

                    </div>
                </div>
                <button class="btn submit-btn mt-3 px-4">تقديم طلبك</button>
            </div>
            <div class="col-md-3 payment">
                <div class="card">
                    <div class="card-body">
                        <h3>قسط</h3>
                        <div class="sub-fee">
                            <h5>رسوم الفصل الدراسي</h5>
                            <h4>2000 SAR</h4>
                        </div>
                        <div class="sub-fee">
                            <h5>مصاريف</h5>
                            <h4>200 SAR</h4>
                        </div>
                        <hr>
                        <div class="total-fee">
                            <h5>مجموع الرسوم</h5>
                            <h4>2200 SAR</h4>
                        </div>


                    </div>
                </div>
                <div class="card">
                    <div class="card-body">
                        <h3>طريقة الدفع او السداد</h3>
                        <div class="payment-method">
                            <div class="single-payment">
                                <div class="form-check">
                                    <input class="form-check-input" name="payment" type="radio" id="radio1">
                                    <label class="form-check-label" for="radio1">
                                    بطاقة الائتمان أو الخصم
                                    </label>
                                </div>
                                <img src="images/all-card.jpeg" alt="">
                            </div>
                            <div class="single-payment last">
                                <div class="form-check">
                                    <input class="form-check-input" name="payment" type="radio" id="radio2">
                                    <label class="form-check-label" for="radio2">
                                    التحويل المصرفي
                                    </label>
                                </div>
                                <img src="images/googlepay.png" alt="" class="pay-img">
                            </div>
                            <div class="bank-details d-none">
                                <ul>
                                    <li><span>الايبان رقم:</span> SA 7165000000257762533001</li>
                                    <li><span>الايبان رقم:</span> SA 0665000000257762533007</li>
                                  
                                </ul>
                                <h6><span>اسم البنك</span>: البنك السعودي للاستثمار</h6>
                                <h6><span>أسم المستفيد</span>: الكلية التقنية السعودية للخدمات الكهربائية</h6>
                            </div>
                            <!-- <div class="single-payment border-b0">
                                <div class="form-check">
                                    <input class="form-check-input" name="payment" type="radio" id="radio3">
                                    <label class="form-check-label" for="radio3">
                                        Bank Transfer
                                    </label>
                                </div>
                                <img src="images/paytm.png" alt="" class="pay-img">
                            </div> -->

                            <button class="btn submit-btn mt-3">يُقدِّم</button>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>










    <div class="modal fade" id="privacy-modal" role="dialog">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h3>سياسة الخصوصية</h3>
                    <button type="button" class="close" data-dismiss="modal" aria-label=""><span>x</span></button>
                </div>

                <div class="modal-body">
                    <div class="term-body">
                        <p>مرحبًا بكم في الكلية التقنية السعودية لخدمات الكهرباء، والمشار إليها هنا أيضًا باسم "SESP". نحن ملتزمون بحماية خصوصية وأمن المعلومات الشخصية لطلابنا. توضح سياسة الخصوصية هذه أنواع المعلومات التي نجمعها من خلال نموذج التسجيل عبر الإنترنت، وكيفية استخدامها وحمايتها، والخيارات المتاحة لك بشأن بياناتك الشخصية.</p>
                        <h6>1. جمع المعلومات </h6>
                        <p>عندما تقوم بالتسجيل للحصول على الدبلوم المقدم في SESP من خلال نموذج التسجيل عبر الإنترنت، فإننا نقوم بجمع الأنواع التالية من المعلومات:</p>
                        <ul>
                            <li>معلومات التعريف الشخصية: الاسم وتاريخ الميلاد والمعرفات الأخرى.</li>
                            <li>معلومات الاتصال: عنوان البريد الإلكتروني ورقم الهاتف والعنوان البريدي.</li>
                            <li>الخلفية التعليمية: التاريخ التعليمي السابق والمؤهلات والمعلومات ذات الصلة.</li>
                            <li>معلومات الدفع: تفاصيل بطاقة الائتمان/الخصم أو معلومات طريقة الدفع الأخرى (ملاحظة: تتم معالجة معلومات الدفع بواسطة معالج دفع آمن تابع لجهة خارجية).</li>
                        </ul>
                        <h6>2. استخدام المعلومات</h6>
                        <p>يتم استخدام المعلومات التي تقدمها للأغراض التالية:</p>
                        <ul>
                            <li>لمعالجة تسجيلك وإدارة حسابك.</li>
                            <li>للتواصل معك بخصوص طلبك أو برنامجك أو الخدمات التي نقدمها.</li>
                            <li>لتقديم الدعم والرد على استفساراتكم.</li>
                            <li>لحفظ السجلات الداخلية والأغراض الإدارية.</li>
                            <li>للامتثال للالتزامات القانونية والحماية من المطالبات القانونية أو النزاعات.</li>
                        </ul>
                        <h6>3. مشاركة البيانات والإفصاح عنها</h6>
                        <p>لا يقوم SESP ببيع أو تأجير المعلومات الشخصية لأطراف ثالثة. قد نكشف عن معلوماتك:</p>
                        <ul>
                            <li>لمقدمي الخدمات الخارجيين الذين يقدمون الخدمات نيابة عنا (على سبيل المثال، معالجة الدفع، وتحليل البيانات).</li>
                            <li>إذا كان ذلك مطلوبًا بموجب القانون، مثل الامتثال لاستدعاء أو إجراء قانوني مماثل.</li>
                            <li>لحماية حقوق أو ملكية أو سلامة SESP أو طلابنا أو الآخرين.</li>

                        </ul>
                        <h6>4. أمن البيانات </h6>
                        <p>نحن ننفذ التدابير الفنية والتنظيمية المناسبة لحماية المعلومات الشخصية التي نجمعها ونعالجها. ومع ذلك، لا يمكن أن يكون أي موقع على الإنترنت آمنًا بنسبة 100%، لذلك لا يمكننا ضمان الأمان المطلق.</p>
                        <h6>5. حقوقك وخياراتك </h6>
                        <p>لديك حقوق معينة فيما يتعلق بالمعلومات الشخصية التي نحتفظ بها عنك. وقد يتضمن ذلك الحق في الوصول إلى معلوماتك الشخصية أو تصحيحها أو حذفها أو تقييد استخدامها، بالإضافة إلى الحق في الاعتراض على معالجة معينة.</p>
                        <h6>6. التغييرات في سياسة الخصوصية هذه</h6>
                        <p>تحتفظ SESP بالحق في تعديل سياسة الخصوصية هذه في أي وقت. سيتم نشر أي تغييرات على موقعنا الإلكتروني، وإذا كان ذلك مناسبًا، سيتم إعلامك بها عبر البريد الإلكتروني.</p>
                        <h6>7. اتصل بنا </h6>
                        <p>إذا كانت لديك أية أسئلة أو استفسارات بشأن سياسة الخصوصية هذه أو معلوماتك الشخصية، فيرجى الاتصال بنا من خلال صفحة اتصل بنا على الويب. <br>
                        من خلال تقديم معلوماتك الشخصية من خلال نموذج التسجيل عبر الإنترنت، فإنك توافق على جمع معلوماتك واستخدامها ومشاركتها كما هو موضح في سياسة الخصوصية هذه.</p>


                    </div>
                </div>

            </div>
        </div>
    </div>
    <div class="modal fade" id="terms-modal" role="dialog">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h3>شروط الاستخدام</h3>
                    <button type="button" class="close" data-dismiss="modal" aria-label=""><span>x</span></button>
                </div>

                <div class="modal-body">
                    <div class="term-body">
                        <p>يتم توفير هذه الخدمة بواسطة SESP. باستخدام هذه الخدمة أو أي خدمات تسجيل أخرى لـ SESP، فإنك توافق على الالتزام بالشروط والأحكام الموضحة هنا. تحتفظ SESP بالحق في تعديل هذه الشروط، والتي ستكون سارية عند استخدامك اللاحق للخدمة. يُنصح بمراجعة هذه الصفحة بانتظام للحصول على التحديثات.</p>
                        <h6>إرشادات الاستخدام للتطبيق عبر الإنترنت</h6>
                        <p>ويهدف هذا التطبيق فقط لتقديم الطلبات الإلكترونية للمؤسسات التعليمية. يجب عليك تقديم معلومات دقيقة وعدم انتحال شخصية الآخرين. يتم تأمين حسابك باستخدام اسم مستخدم وكلمة مرور فريدين، وأنت مسؤول عنهما. في حالة فقدان بيانات اعتماد تسجيل الدخول، اتصل بالدعم الفني لدينا وزودنا بتفاصيلك الكاملة للحصول على المساعدة. قم بإبلاغ SESP على الفور إذا كنت تشك في الوصول غير المصرح به إلى الحساب.
                            <br>
                            الالتزام بمعايير أمان SESP والامتناع عن الوصول غير المصرح به إلى النظام أو طرق استرجاع المعلومات. وأي انتهاك قد يؤدي إلى عواقب وخيمة، بما في ذلك إنهاء الوصول.
                            <br>
                            تجنب أي إجراءات من شأنها تعطيل نظام التقديم عبر الإنترنت أو فرض عبئًا لا داعي له على أنظمة SESP.</p>
                        <h6>الروابط الخارجية ومحتوى الطرف الثالث</h6>
                        <p>SESP ليست مسؤولة عن محتوى أو إمكانية الوصول إلى المواقع الخارجية المرتبطة من خلال خدمتنا، كما أنها لا تؤيد أي منتجات أو معلومات تقدمها هذه المواقع الخارجية.</p>
                        <h6>معلوماتك</h6>
                        <p>البيانات المدخلة في طلبك متاحة للمؤسسة ولكن لن تتم مراجعتها إلا عند التقديم. بمجرد تقديم طلبك، يصبح طلبك ملكًا للمؤسسة ويمكن تعديله وفقًا لسياساتها. سيتم الاحتفاظ ببيانات طلبك لمدة عام واحد بعد آخر وصول لك.</p>
                        <h6>الامتثال القانوني</h6>
                        <p>يجب أن يتوافق استخدامك لهذه الخدمة مع جميع القوانين ذات الصلة. الاستخدام غير المصرح به ممنوع منعا باتا ويعاقب عليه القانون. تخضع هذه الشروط لقانون المملكة العربية السعودية، وأي شروط غير قابلة للتنفيذ لا تؤثر على الباقي.</p>
                        <h6>معلومات حقوق النشر والعلامات التجارية</h6>
                        <p>جميع المحتويات محمية بموجب قانون حقوق النشر. يُحظر أي استخدام غير مصرح به، بما في ذلك التعديل أو النقل أو إنشاء أعمال مشتقة. إن كود HTML والشعارات محمية أيضًا ولا يجوز تكرارها أو استخدامها دون إذن.</p>
                        <h6>إخلاء المسؤولية والضمان</h6>
                        <p>يوفر SESP هذه الخدمة "كما هي" دون أي ضمانات من أي نوع. لا يتحمل SESP المسؤولية عن أي انقطاعات أو أخطاء أو عدم دقة في الخدمة، ولا عن أي أضرار تنشأ عن استخدامك للخدمة أو سلوكك المتعلق بالخدمة.</p>
                        <h6>تحديد المسؤوليات والتعويض</h6>
                        <p>تقتصر مسؤولية SESP عن أي أضرار على 300 ريال سعودي كحد أقصى. وأنت توافق على تعويض SESP عن أي أضرار تنشأ عن استخدامك للخدمة أو المحتوى الذي تنشره. في حالة انتهاك شروط الاستخدام، يحق لـ SESP الحصول على تعويض عادل. <br>
                        سوف يقوم SESP بإخطارك بأي مطالبات قانونية وقد يساعدك في الدفاع عنك على نفقتك الخاصة.</p>
                        <h6>القنون والشريعة السائدة</h6>
                        <p>تخضع شروط الاستخدام هذه وتفسر وفقًا لقوانين المملكة العربية السعودية. أي نزاعات تنشأ بموجب شروط الاستخدام هذه أو فيما يتعلق بها تخضع للاختصاص القضائي الحصري لمحاكم المملكة العربية السعودية.</p>
                        <h6>تعديلات على شروط الاستخدام</h6>
                        <p>تحتفظ SESP بالحق في تعديل شروط الاستخدام هذه في أي وقت. وتصبح هذه التعديلات سارية فور نشرها. استمرار استخدامك للخدمة يشكل قبولا لهذه التغييرات. نوصي بمراجعة هذه الشروط بشكل دوري لمعرفة أي تحديثات أو تغييرات.</p>
                        <h6>الاتصال والتواصل</h6>
                        <p>بالنسبة لأية استفسارات أو مخاوف بخصوص شروط الاستخدام هذه أو خدمة التقديم عبر الإنترنت، يرجى الاتصال بـ SESP من خلال قنوات الاتصال المخصصة المتوفرة على موقعنا. تلتزم SESP بمعالجة استفساراتك بسرعة وكفاءة.</p>
                        <h6>اتفاق كامل</h6>
                        <p>تشكل شروط الاستخدام هذه الاتفاقية الكاملة بينك وبين SESP فيما يتعلق باستخدام خدمة التقديم عبر الإنترنت. وهي تحل محل جميع الاتصالات والمقترحات السابقة أو المعاصرة، سواء كانت إلكترونية أو شفهية أو مكتوبة، بينك وبين SESP.</p>
                        <h6>الإقرار بالشروط وقبولها</h6>
                        <p>من خلال الوصول إلى خدمة تطبيق SESP عبر الإنترنت واستخدامها، فإنك تقر بأنك قد قرأت شروط الاستخدام هذه وفهمتها ووافقت على الالتزام بها. إذا كنت لا توافق على أي جزء من هذه الشروط، فيجب عليك التوقف عن الوصول إلى الخدمة واستخدامها على الفور.</p>
                        <h6>تاريخ النفاذ</h6>
                        <p>تسري شروط الاستخدام هذه اعتبارًا من [أدخل تاريخ السريان] وستظل سارية المفعول إلا فيما يتعلق بأي تغييرات في أحكامها في المستقبل، والتي ستكون سارية المفعول فور نشرها على هذه الصفحة. <br>
                        نشكرك على اختيار SESP لاحتياجاتك التطبيقية التعليمية ونتطلع إلى مساعدتك في رحلتك الأكاديمية.</p>

                    </div>
                </div>

            </div>
        </div>
    </div>
    <div class="modal fade" id="add-course" role="dialog">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h3>إضافة دورة</h3>
                    <button type="button" class="close" data-dismiss="modal" aria-label=""><span>x</span></button>
                </div>

                <div class="modal-body">

                    <div class="longcrs-form">
                        <div class="row">
                            <div class="col-md-5">
                                <div class="mb-25 form-grp">
                                    <label for="diploma-type">نوع الدبلوم</label>
                                    <select class="form-control" id="diploma-type">
                                        <option>SESP الدورات</option>
                                        <option>دورات قصيرة</option>
                                        <option>أي دبلوم جديد</option>

                                    </select>

                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="mb-25 form-grp">
                                    <label for="diploma-type">الفصل الدراسي/السنة</label>
                                    <select class="form-control" id="diploma-type">
                                        <option>يسقط</option>
                                        <option>ربيع</option>


                                    </select>

                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="mb-25 form-grp">
                                    <label for="diploma-type">برنامج</label>
                                    <select class="form-control" id="diploma-type">
                                        <option>دبلوم مشارك في الصحة والسلامة والبيئة</option>
                                        <option>الدبلوم المشارك في هندسة التشغيل والصيانة (ADOME)</option>
                                        <option>الدبلوم المشارك في التكنولوجيا (ADT)</option>

                                    </select>

                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="form-grp">
                                    <label for="diploma-type">عنوان الدورة</label>
                                    <select class="form-control" id="diploma-type">
                                        <option>تكنولوجيا الصحة والسلامة والبيئة (HSET)</option>
                                        <option>تكنولوجيا الصحة والسلامة والبيئة (HSET)</option>
                                        <option>تكنولوجيا الصحة والسلامة والبيئة (HSET)</option>

                                    </select>

                                </div>
                            </div>
                            <div class="col-md-12">
                                <button class="next-btn mt-4">إرسال</button>
                            </div>

                        </div>

                    </div>

                </div>

            </div>
        </div>
    </div>

    <script src="https://kit.fontawesome.com/16b0815225.js" crossorigin="anonymous"></script>
    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"
        integrity="sha384-DfXdz2htPH0lsSSs5nCTpuj/zy4C+OGpamoFVy38MVBnE+IbbVYUew+OrCXaRkfj" crossorigin="anonymous">
    </script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.2/dist/js/bootstrap.min.js"
        integrity="sha384-+sLIOodYLS7CIrQpBjl+C7nPvqq+FbNUBDunl/OZv93DB7Ln/533i8e/mZXLi/P+" crossorigin="anonymous">
    </script>
    <script src="https://www.google.com/recaptcha/api.js?onload=onloadCallback"></script>
    <script>
        $(".course-tbl").on('click', '.remove-tr', function () {
            $(this).closest('tr').remove();
        });
    </script>

    <script>
         function changeFuncloc() {
            var selectBox = document.getElementById("main-location-type");
            var selectedValue = selectBox.options[selectBox.selectedIndex].value;
            if (selectedValue=="1") {            
                $("#riyadh-main").show()
                $("#makkah-main").hide()
                $("#medina-main").hide()
                $("#eastern-main").hide()
                $("#qassim-main").hide()
                $("#asir-main").hide()
                $("#tabuk-main").hide()
                $("#hail-main").hide()
                $("#northern-main").hide()
                $("#jizan-main").hide()
                $("#najran-main").hide()
                $("#bahah-main").hide()
                $("#jawf-main").hide()
            }
            else if (selectedValue=="2") {            
                $("#makkah-main").show()
                $("#riyadh-main").hide()
                $("#medina-main").hide()
                $("#eastern-main").hide()
                $("#qassim-main").hide()
                $("#asir-main").hide()
                $("#tabuk-main").hide()
                $("#hail-main").hide()
                $("#northern-main").hide()
                $("#jizan-main").hide()
                $("#najran-main").hide()
                $("#bahah-main").hide()
                $("#jawf-main").hide()
            }
            else if (selectedValue=="3") {            
                $("#medina-main").show()
                $("#makkah-main").hide()
                $("#riyadh-main").hide()
                $("#eastern-main").hide()
                $("#qassim-main").hide()
                $("#asir-main").hide()
                $("#tabuk-main").hide()
                $("#hail-main").hide()
                $("#northern-main").hide()
                $("#jizan-main").hide()
                $("#najran-main").hide()
                $("#bahah-main").hide()
                $("#jawf-main").hide()
            }
            else if (selectedValue=="4") {            
                $("#eastern-main").show()
                $("#makkah-main").hide()
                $("#medina-main").hide()
                $("#riyadh-main").hide()
                $("#qassim-main").hide()
                $("#asir-main").hide()
                $("#tabuk-main").hide()
                $("#hail-main").hide()
                $("#northern-main").hide()
                $("#jizan-main").hide()
                $("#najran-main").hide()
                $("#bahah-main").hide()
                $("#jawf-main").hide()
            }
            else if (selectedValue=="5") {            
                $("#qassim-main").show()
                $("#riyadh-main").hide()
                $("#makkah-main").hide()
                $("#medina-main").hide()
                $("#eastern-main").hide()
                $("#asir-main").hide()
                $("#tabuk-main").hide()
                $("#hail-main").hide()
                $("#northern-main").hide()
                $("#jizan-main").hide()
                $("#najran-main").hide()
                $("#bahah-main").hide()
                $("#jawf-main").hide()
            }
            else if (selectedValue=="6") {            
                $("#asir-main").show()
                $("#riyadh-main").hide()
                $("#makkah-main").hide()
                $("#medina-main").hide()
                $("#eastern-main").hide()
                $("#qassim-main").hide()
                $("#tabuk-main").hide()
                $("#hail-main").hide()
                $("#northern-main").hide()
                $("#jizan-main").hide()
                $("#najran-main").hide()
                $("#bahah-main").hide()
                $("#jawf-main").hide()
            }
            else if (selectedValue=="7") {            
                $("#tabuk-main").show()
                $("#riyadh-main").hide()
                $("#makkah-main").hide()
                $("#medina-main").hide()
                $("#eastern-main").hide()
                $("#qassim-main").hide()
                $("#asir-main").hide()
                $("#hail-main").hide()
                $("#northern-main").hide()
                $("#jizan-main").hide()
                $("#najran-main").hide()
                $("#bahah-main").hide()
                $("#jawf-main").hide()
            }
            else if (selectedValue=="8") {            
                $("#hail-main").show()
                $("#riyadh-main").hide()
                $("#makkah-main").hide()
                $("#medina-main").hide()
                $("#eastern-main").hide()
                $("#qassim-main").hide()
                $("#asir-main").hide()
                $("#tabuk-main").hide()
                $("#northern-main").hide()
                $("#jizan-main").hide()
                $("#najran-main").hide()
                $("#bahah-main").hide()
                $("#jawf-main").hide()
            }
            else if (selectedValue=="9") {            
                $("#northern-main").show()
                $("#riyadh-main").hide()
                $("#makkah-main").hide()
                $("#medina-main").hide()
                $("#eastern-main").hide()
                $("#qassim-main").hide()
                $("#asir-main").hide()
                $("#tabuk-main").hide()
                $("#hail-main").hide()
                $("#jizan-main").hide()
                $("#najran-main").hide()
                $("#bahah-main").hide()
                $("#jawf-main").hide()
            }
            else if (selectedValue=="10") {            
                $("#jizan-main").show()
                $("#riyadh-main").hide()
                $("#makkah-main").hide()
                $("#medina-main").hide()
                $("#eastern-main").hide()
                $("#qassim-main").hide()
                $("#asir-main").hide()
                $("#tabuk-main").hide()
                $("#hail-main").hide()
                $("#northern-main").hide()
                $("#najran-main").hide()
                $("#bahah-main").hide()
                $("#jawf-main").hide()
            }
            else if (selectedValue=="11") {            
                $("#najran-main").show()
                $("#riyadh-main").hide()
                $("#makkah-main").hide()
                $("#medina-main").hide()
                $("#eastern-main").hide()
                $("#qassim-main").hide()
                $("#asir-main").hide()
                $("#tabuk-main").hide()
                $("#hail-main").hide()
                $("#northern-main").hide()
                $("#jizan-main").hide()
                $("#bahah-main").hide()
                $("#jawf-main").hide()
            }
            else if (selectedValue=="12") {            
                $("#bahah-main").show()
                $("#riyadh-main").hide()
                $("#makkah-main").hide()
                $("#medina-main").hide()
                $("#eastern-main").hide()
                $("#qassim-main").hide()
                $("#asir-main").hide()
                $("#tabuk-main").hide()
                $("#hail-main").hide()
                $("#northern-main").hide()
                $("#jizan-main").hide()
                $("#najran-main").hide()
                $("#jawf-main").hide()
            }
            else if (selectedValue=="13") {            
                $("#jawf-main").show()
                $("#riyadh-main").hide()
                $("#makkah-main").hide()
                $("#medina-main").hide()
                $("#eastern-main").hide()
                $("#qassim-main").hide()
                $("#asir-main").hide()
                $("#tabuk-main").hide()
                $("#hail-main").hide()
                $("#northern-main").hide()
                $("#jizan-main").hide()
                $("#najran-main").hide()
                $("#bahah-main").hide()
            }
            
        }
    </script>
      <script>
    $(document).ready(function(){
        $(".bank-details").hide();

        $('input[type="radio"]').change(function(){
            if($('#radio2').is(':checked')) {
                $(".bank-details").show();
                $(".bank-details").removeClass("d-none");
            } else {
                $(".bank-details").hide();
            }
        });
    });
</script>
</body>

</html>