
    // Enhanced form validation and submission
    document.getElementById('loginForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        const email = document.getElementById('email').value;
        const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
        const button = document.querySelector('.get-otp-btn');
        const buttonText = document.querySelector('.btn-text');
        
        if (!emailRegex.test(email)) {
            // Shake animation for invalid email
            document.querySelector('.input-field').style.animation = 'shake 0.5s ease-in-out';
            setTimeout(() => {
                document.querySelector('.input-field').style.animation = '';
            }, 500);
            
            alert('Please enter a valid email address');
            return;
        }
        
        // Loading state
        button.classList.add('loading');
        buttonText.textContent = 'Sending OTP...';
        
        // Simulate API call
        setTimeout(() => {
            // Redirect to OTP page directly without success animation
            window.location.href = 'otp.html';
        }, 2000);
    });

    // Safari-compatible input handling
    const emailInput = document.getElementById('email');
    const emailLabel = document.querySelector('label[for="email"]');

    // Handle focus state
    emailInput.addEventListener('focus', function() {
        emailLabel.classList.add('active');
        // Set placeholder for focus helper
        this.setAttribute('data-focused', 'true');
    });

    // Handle blur state
    emailInput.addEventListener('blur', function() {
        this.removeAttribute('data-focused');
        // Only remove active class if input is empty
        if (!this.value.trim()) {
            emailLabel.classList.remove('active');
        }
    });

    // Handle input changes
    emailInput.addEventListener('input', function() {
        if (this.value.trim()) {
            emailLabel.classList.add('active');
        } else {
            // Only remove if not focused
            if (!this.hasAttribute('data-focused')) {
                emailLabel.classList.remove('active');
            }
        }
    });

    // Initial check for pre-filled values (e.g., autofill)
    function checkInitialValue() {
        if (emailInput.value.trim()) {
            emailLabel.classList.add('active');
        }
    }

    // Check on page load and after a short delay for autofill
    checkInitialValue();
    setTimeout(checkInitialValue, 100);
    setTimeout(checkInitialValue, 500);

    // Smooth scroll and parallax effects
    const particles = document.querySelectorAll('.particle');
    
    window.addEventListener('scroll', () => {
        const scrolled = window.pageYOffset;
        const rate = scrolled * -0.5;
        
        particles.forEach((particle, index) => {
            const speed = (index + 1) * 0.1;
            const transform = `translateY(${rate * speed}px) rotate(${scrolled * 0.1}deg)`;
            particle.style.transform = transform;
            particle.style.webkitTransform = transform;
        });
    });

    // Add typing effect for the title
    const title = document.querySelector('.login-form-container h4');
    const originalText = title.textContent;
    title.textContent = '';
    
    let i = 0;
    const typeWriter = () => {
        if (i < originalText.length) {
            title.textContent += originalText.charAt(i);
            i++;
            setTimeout(typeWriter, 100);
        }
    };
    
    // Start typing effect after page load
    setTimeout(typeWriter, 500);

 
// otp page


// loader




